// rdcatchd.cpp
//
// The Rivendell Netcatcher Daemon
//
//   (C) Copyright 2002-2007 Fred Gleason <fredg@paravelsystems.com>
//
//      $Id: local_macros.cpp,v 1.1 2008/10/02 18:52:13 fredg Exp $
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License version 2 as
//   published by the Free Software Foundation.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public
//   License along with this program; if not, write to the Free Software
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <rdcart.h>

#include <rdcatchd.h>

void MainObject::RunLocalMacros(RDMacro *rml)
{
  RDCart *cart;
  RDCut *cut;
  RDDeck *deck;
  int chan;
  unsigned cartnum;
  unsigned cutnum;
  unsigned len;
  QDateTime dt;

  switch(rml->command()) {
      case RDMacro::EX:
	cart=new RDCart(rml->arg(0).toUInt());
	if(cart->exists()) {
	  if(ExecuteMacroCart(cart)) {
	    if(rml->echoRequested()) {
	      rml->acknowledge(true);
	      catch_ripc->sendRml(rml);
	    }
	    delete cart;
	    return;
	  }
	}
	else {
	  if(rml->echoRequested()) {
	    rml->acknowledge(false);
	    catch_ripc->sendRml(rml);
	  }
	}
	delete cart;
	return;
	break;

      case RDMacro::RS:
	//
	// Validate Parameters
	//
	if(rml->argQuantity()!=4) {
	  if(rml->echoRequested()) {
	    rml->acknowledge(false);
	    catch_ripc->sendRml(rml);
	  }
	  return;
	}
	chan=rml->arg(0).toInt();
	cartnum=rml->arg(1).toUInt();
	cutnum=rml->arg(2).toUInt();
	len=rml->arg(3).toUInt();
	if((chan<=0)||(chan>MAX_DECKS)||(cartnum>999999)||(cutnum>999)
	   ||len==0) {
	  if(rml->echoRequested()) {
	    rml->acknowledge(false);
	    catch_ripc->sendRml(rml);
	  }
	  return;
	}
	if(catch_record_deck_status[chan-1]!=RDDeck::Idle) {
	  if(rml->echoRequested()) {
	    rml->acknowledge(false);
	    catch_ripc->sendRml(rml);
	  }
	  return;
	}
	cut=new RDCut(cartnum,cutnum);
	deck=new RDDeck(catch_config->stationName(),chan);
	if((!cut->exists())||(!deck->isActive())) {
	  delete cut;
	  delete deck;
	  if(rml->echoRequested()) {
	    rml->acknowledge(false);
	    catch_ripc->sendRml(rml);
	  }
	  return;
	}

	//
	// Create Event
	//
	dt=QDateTime(QDate::currentDate(),QTime::currentTime());
	catch_events.push_back(CatchEvent());
	catch_events.back().setId(GetNextDynamicId());
	catch_events.back().setIsActive(true);
	catch_events.back().setOneShot(true);
	catch_events.back().setType(RDRecording::Recording);
	catch_events.back().setChannel(chan);
	catch_events.back().setCutName(cut->cutName());
	catch_events.back().setDayOfWeek(dt.date().dayOfWeek(),true);
	catch_events.back().setStartTime(dt.time());
	catch_events.back().setEndType(RDRecording::LengthEnd);
	catch_events.back().setLength(len);
	catch_events.back().
	  setFormat((RDCae::AudioCoding)deck->defaultFormat());
	catch_events.back().setChannels(deck->defaultChannels());
	catch_events.back().setSampleRate(deck->defaultSamprate());
	catch_events.back().setBitrate(deck->defaultBitrate());
	catch_events.back().setNormalizeLevel(deck->defaultThreshold());
	delete cut;
	delete deck;
	StartRecording(catch_events.size()-1);
	if(rml->echoRequested()) {
	  rml->acknowledge(true);
	  catch_ripc->sendRml(rml);
	}
	break;

      case RDMacro::RR:
	if(rml->argQuantity()!=1) {
	  if(rml->echoRequested()) {
	    rml->acknowledge(false);
	    catch_ripc->sendRml(rml);
	  }
	  return;
	}
	chan=rml->arg(0).toInt();
	if((chan>0)&&(chan<(MAX_DECKS+1))) {
	  switch(catch_record_deck_status[chan-1]) {
	    case RDDeck::Recording:
	      catch_record_aborting[chan-1]=true;
	      catch_cae->stopRecord(catch_record_card[chan-1],
				    catch_record_stream[chan-1]);
	      break;
	      
	    case RDDeck::Waiting:
	      startTimerData(catch_record_id[chan-1]);
	      break;
	      
	    default:
	      break;
	  }
	}
	if(rml->echoRequested()) {
	  rml->acknowledge(true);
	  catch_ripc->sendRml(rml);
	}
	break;

      default:
	break;
  }
}
